/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.core.spi.remote.emf;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.mylyn.reviews.core.spi.remote.AbstractRemoteService;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.AbstractRemoteEmfFactoryProvider;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.RemoteEmfConsumer;

public abstract class AbstractRemoteEmfFactory<EParentObjectType extends EObject, EObjectType, LocalKeyType, RemoteType, RemoteKeyType, ObjectCurrentType> {
    private final Map<UniqueLocalReference<EParentObjectType, LocalKeyType>, RemoteEmfConsumer<EParentObjectType, EObjectType, LocalKeyType, RemoteType, RemoteKeyType, ObjectCurrentType>> consumerForLocalKey = new HashMap<UniqueLocalReference<EParentObjectType, LocalKeyType>, RemoteEmfConsumer<EParentObjectType, EObjectType, LocalKeyType, RemoteType, RemoteKeyType, ObjectCurrentType>>();
    private final EReference parentReference;
    private final EAttribute localKeyAttribute;
    private final AbstractRemoteEmfFactoryProvider<?, ?> factoryProvider;

    public AbstractRemoteEmfFactory(AbstractRemoteEmfFactoryProvider<?, ?> factoryProvider, EReference parentReference, EAttribute localKeyAttribute) {
        this.factoryProvider = factoryProvider;
        this.parentReference = parentReference;
        this.localKeyAttribute = localKeyAttribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteEmfConsumer<EParentObjectType, EObjectType, LocalKeyType, RemoteType, RemoteKeyType, ObjectCurrentType> getConsumerForRemoteKey(EParentObjectType parentObject, RemoteKeyType remoteKey) {
        LocalKeyType localKey = this.getLocalKeyForRemoteKey(remoteKey);
        Map<UniqueLocalReference<EParentObjectType, LocalKeyType>, RemoteEmfConsumer<EParentObjectType, EObjectType, LocalKeyType, RemoteType, RemoteKeyType, ObjectCurrentType>> map = this.consumerForLocalKey;
        synchronized (map) {
            RemoteEmfConsumer<EParentObjectType, Object, LocalKeyType, Object, RemoteKeyType, ObjectCurrentType> consumer = null;
            if (localKey != null) {
                consumer = this.getConsumerForLocalKey(parentObject, localKey);
            }
            if (consumer == null) {
                consumer = new RemoteEmfConsumer(this, parentObject, null, localKey, null, remoteKey);
                this.assignConsumer(parentObject, localKey, consumer);
            } else {
                consumer.setRemoteKey(remoteKey);
            }
            return consumer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteEmfConsumer<EParentObjectType, EObjectType, LocalKeyType, RemoteType, RemoteKeyType, ObjectCurrentType> getConsumerForRemoteObject(EParentObjectType parentObject, RemoteType remoteObject) {
        Map<UniqueLocalReference<EParentObjectType, LocalKeyType>, RemoteEmfConsumer<EParentObjectType, EObjectType, LocalKeyType, RemoteType, RemoteKeyType, ObjectCurrentType>> map = this.consumerForLocalKey;
        synchronized (map) {
            RemoteKeyType remoteKey = this.getRemoteKey(remoteObject);
            LocalKeyType localKey = this.getLocalKeyForRemoteKey(remoteKey);
            RemoteEmfConsumer<EParentObjectType, Object, LocalKeyType, RemoteType, RemoteKeyType, ObjectCurrentType> consumer = this.findConsumer(parentObject, localKey);
            if (consumer == null) {
                consumer = new RemoteEmfConsumer(this, parentObject, null, localKey, remoteObject, remoteKey);
                this.assignConsumer(parentObject, localKey, consumer);
            } else {
                consumer.setRemoteObject(remoteObject);
            }
            return consumer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteEmfConsumer<EParentObjectType, EObjectType, LocalKeyType, RemoteType, RemoteKeyType, ObjectCurrentType> getConsumerForLocalKey(EParentObjectType parentObject, LocalKeyType localKey) {
        RemoteEmfConsumer<EParentObjectType, Object, LocalKeyType, Object, Object, ObjectCurrentType> consumer = null;
        Map<UniqueLocalReference<EParentObjectType, LocalKeyType>, RemoteEmfConsumer<EParentObjectType, EObjectType, LocalKeyType, RemoteType, RemoteKeyType, ObjectCurrentType>> map = this.consumerForLocalKey;
        synchronized (map) {
            consumer = this.findConsumer(parentObject, localKey);
        }
        if (consumer == null) {
            EObjectType eo = this.open(parentObject, localKey);
            Map<UniqueLocalReference<EParentObjectType, LocalKeyType>, RemoteEmfConsumer<EParentObjectType, EObjectType, LocalKeyType, RemoteType, RemoteKeyType, ObjectCurrentType>> map2 = this.consumerForLocalKey;
            synchronized (map2) {
                if (eo != null) {
                    EObjectType modelObject = eo;
                    consumer = new RemoteEmfConsumer(this, parentObject, modelObject, localKey, null, null);
                    this.assignConsumer(parentObject, localKey, consumer);
                }
                if (consumer == null) {
                    consumer = new RemoteEmfConsumer(this, parentObject, null, localKey, null, null);
                    this.assignConsumer(parentObject, localKey, consumer);
                }
            }
        }
        return consumer;
    }

    protected EObjectType open(EParentObjectType parentObject, LocalKeyType localKey) {
        ObjectFinder finder = new ObjectFinder(this, parentObject, localKey);
        this.getService().modelExec(finder, true);
        return finder.foundObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteEmfConsumer<EParentObjectType, EObjectType, LocalKeyType, RemoteType, RemoteKeyType, ObjectCurrentType> getConsumerForModel(EParentObjectType parentObject, EObjectType modelObject) {
        Map<UniqueLocalReference<EParentObjectType, LocalKeyType>, RemoteEmfConsumer<EParentObjectType, EObjectType, LocalKeyType, RemoteType, RemoteKeyType, ObjectCurrentType>> map = this.consumerForLocalKey;
        synchronized (map) {
            RemoteEmfConsumer<EParentObjectType, EObjectType, LocalKeyType, Object, Object, ObjectCurrentType> consumer = null;
            LocalKeyType localKey = this.getLocalKey(parentObject, modelObject);
            if (localKey != null) {
                consumer = this.findConsumer(parentObject, localKey);
            }
            if (consumer == null) {
                consumer = new RemoteEmfConsumer(this, parentObject, modelObject, localKey, null, null);
                this.assignConsumer(parentObject, localKey, consumer);
            }
            return consumer;
        }
    }

    private RemoteEmfConsumer<EParentObjectType, EObjectType, LocalKeyType, RemoteType, RemoteKeyType, ObjectCurrentType> findConsumer(EParentObjectType parentObject, LocalKeyType localKey) {
        UniqueLocalReference<EParentObjectType, LocalKeyType> key = new UniqueLocalReference<EParentObjectType, LocalKeyType>(parentObject, localKey);
        return this.consumerForLocalKey.get(key);
    }

    private RemoteEmfConsumer<EParentObjectType, EObjectType, LocalKeyType, RemoteType, RemoteKeyType, ObjectCurrentType> assignConsumer(EParentObjectType parentObject, LocalKeyType localKey, RemoteEmfConsumer<EParentObjectType, EObjectType, LocalKeyType, RemoteType, RemoteKeyType, ObjectCurrentType> consumer) {
        UniqueLocalReference<EParentObjectType, LocalKeyType> key = new UniqueLocalReference<EParentObjectType, LocalKeyType>(parentObject, localKey);
        return this.consumerForLocalKey.put(key, consumer);
    }

    public void removeConsumer(RemoteEmfConsumer<EParentObjectType, EObjectType, LocalKeyType, RemoteType, RemoteKeyType, ObjectCurrentType> consumer) {
        EParentObjectType parentObject = consumer.getParentObject();
        LocalKeyType localKey = consumer.getLocalKey();
        if (parentObject != null && localKey != null) {
            UniqueLocalReference<EParentObjectType, LocalKeyType> key = new UniqueLocalReference<EParentObjectType, LocalKeyType>(parentObject, localKey);
            this.consumerForLocalKey.remove(key);
        }
    }

    public LocalKeyType getLocalKey(EParentObjectType parentObject, EObjectType modelObject) {
        if (modelObject instanceof EObject) {
            EObject eObject = (EObject)modelObject;
            return (LocalKeyType)eObject.eGet((EStructuralFeature)this.getLocalKeyAttribute());
        }
        return null;
    }

    public LocalKeyType getLocalKeyForRemoteObject(RemoteType remoteObject) {
        return this.getLocalKeyForRemoteKey(this.getRemoteKey(remoteObject));
    }

    public abstract LocalKeyType getLocalKeyForRemoteKey(RemoteKeyType var1);

    public abstract RemoteKeyType getRemoteKey(RemoteType var1);

    public RemoteKeyType getRemoteKeyForLocalKey(EParentObjectType parentObject, LocalKeyType localKey) {
        RemoteType remoteObject = this.getRemoteObjectForLocalKey(parentObject, localKey);
        if (remoteObject != null) {
            return this.getRemoteKey(remoteObject);
        }
        return null;
    }

    public RemoteType getRemoteObjectForLocalKey(EParentObjectType parentObject, LocalKeyType localKey) {
        return null;
    }

    public boolean isAsynchronous() {
        return true;
    }

    public abstract RemoteType pull(EParentObjectType var1, RemoteKeyType var2, IProgressMonitor var3) throws CoreException;

    public boolean isPullNeeded(EParentObjectType parent, EObjectType object, RemoteType remote) {
        return object == null || remote == null;
    }

    protected abstract EObjectType createModel(EParentObjectType var1, RemoteType var2);

    public boolean isCreateModelNeeded(EParentObjectType parentObject, EObjectType modelObject) {
        return modelObject == null;
    }

    public boolean updateModel(EParentObjectType parentObject, EObjectType modelObject, RemoteType remoteObject) {
        return false;
    }

    public boolean isUpdateModelNeeded(EParentObjectType parentObject, EObjectType modelObject, RemoteType remote) {
        return true;
    }

    public final EObjectType get(EParentObjectType parentObject, LocalKeyType localKey, RemoteKeyType remoteKey) {
        RemoteEmfConsumer<EParentObjectType, EObjectType, LocalKeyType, RemoteType, RemoteKeyType, ObjectCurrentType> consumer = null;
        if (localKey != null) {
            consumer = this.getConsumerForLocalKey(parentObject, localKey);
        }
        if (consumer == null && remoteKey != null) {
            consumer = this.getConsumerForRemoteKey(parentObject, remoteKey);
        }
        if (consumer != null) {
            return consumer.getModelObject();
        }
        return null;
    }

    public EReference getParentReference() {
        return this.parentReference;
    }

    public EAttribute getLocalKeyAttribute() {
        return this.localKeyAttribute;
    }

    public AbstractRemoteService getService() {
        return this.getFactoryProvider().getService();
    }

    public AbstractRemoteEmfFactoryProvider<?, ?> getFactoryProvider() {
        return this.factoryProvider;
    }

    public String getModelDescription(EParentObjectType parentObject, EObjectType object, LocalKeyType localKey) {
        return String.valueOf(this.getParentReference().getEReferenceType().getName()) + " " + localKey;
    }

    static class ObjectFinder
    implements Runnable {
        EObjectType foundObject;
        EParentObjectType parentObject;
        LocalKeyType localKey;
        final /* synthetic */ AbstractRemoteEmfFactory this$0;

        private ObjectFinder(EParentObjectType parentObject, LocalKeyType localKey) {
            this.this$0 = var1_1;
            this.parentObject = parentObject;
            this.localKey = localKey;
        }

        @Override
        public void run() {
            Object parentField = this.parentObject.eGet((EStructuralFeature)this.this$0.parentReference);
            if (parentField instanceof List) {
                List members = (List)parentField;
                for (Object object : members) {
                    Object currentKey;
                    if (!(object instanceof EObject) || (currentKey = this.this$0.getLocalKey(this.parentObject, object)) == null || !this.localKey.equals(currentKey)) continue;
                    this.foundObject = object;
                    break;
                }
            }
        }
    }

    class UniqueLocalReference<P, L> {
        P parent;
        L localKey;

        UniqueLocalReference(P parent, L localKey) {
            Assert.isLegal((parent != null ? 1 : 0) != 0, (String)"Internal Exception: Parent must be specified.");
            Assert.isLegal((localKey != null ? 1 : 0) != 0, (String)"Internal Exception: Local key must be specified.");
            this.parent = parent;
            this.localKey = localKey;
        }

        public boolean equals(Object object) {
            if (object instanceof UniqueLocalReference) {
                UniqueLocalReference reference = (UniqueLocalReference)object;
                return this.parent.equals(reference.parent) && this.localKey.equals(reference.localKey);
            }
            return false;
        }

        public int hashCode() {
            return this.parent.hashCode() + 31 * this.localKey.hashCode();
        }
    }
}

