/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.reviews.ui.annotations;

import java.util.Date;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.mylyn.internal.reviews.ui.annotations.CommentAnnotationHoverInput;
import org.eclipse.mylyn.internal.reviews.ui.annotations.InlineCommentEditor;
import org.eclipse.mylyn.internal.reviews.ui.annotations.Messages;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.reviews.core.model.IComment;
import org.eclipse.mylyn.reviews.core.model.IFileItem;
import org.eclipse.mylyn.reviews.core.model.IFileVersion;
import org.eclipse.mylyn.reviews.core.model.ILineLocation;
import org.eclipse.mylyn.reviews.core.model.ILineRange;
import org.eclipse.mylyn.reviews.core.model.IReviewItem;
import org.eclipse.mylyn.reviews.core.model.IReviewsFactory;
import org.eclipse.mylyn.reviews.core.model.IUser;
import org.eclipse.mylyn.reviews.core.spi.ReviewsConnector;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.RemoteEmfConsumer;
import org.eclipse.mylyn.reviews.core.spi.remote.review.IReviewRemoteFactoryProvider;
import org.eclipse.mylyn.reviews.ui.ReviewBehavior;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.swt.widgets.Display;

public class InlineCommentSubmitter {
    public static final String JOB_FAMILY = "CommentPopupDialogJobFamily";
    private final IReviewItem reviewitem;
    private final LineRange range;
    private final CommentAnnotationHoverInput annotationInput;
    private final InlineCommentEditor commentEditor;

    public InlineCommentSubmitter(IReviewItem reviewitem, LineRange range, CommentAnnotationHoverInput annotationInput, InlineCommentEditor commentEditor) {
        this.reviewitem = reviewitem;
        this.range = range;
        this.annotationInput = annotationInput;
        this.commentEditor = commentEditor;
    }

    public void saveComment() {
        if (!this.commentEditor.getState().equals((Object)InlineCommentEditor.CommentEditorState.VIEW) && (this.commentEditor.getState().equals((Object)InlineCommentEditor.CommentEditorState.DISCARD) || StringUtils.isNotEmpty((String)this.commentEditor.getCommentEditorText().getText().trim()))) {
            IComment comment = IReviewsFactory.INSTANCE.createComment();
            comment.setDescription(this.commentEditor.getCommentEditorText().getText().trim());
            if (this.commentEditor.getCurrentComment().isDraft()) {
                comment.setId(this.commentEditor.getCurrentComment().getId());
            }
            comment.setDraft(true);
            comment.setAuthor(this.getCurrentUser());
            comment.setCreationDate(new Date());
            ILineLocation location = this.getSelectedLineLocation();
            if (location != null) {
                comment.getLocations().add(location);
            }
            this.performOperation(comment);
            this.commentEditor.forceDispose();
        }
    }

    private void performOperation(final IComment comment) {
        final IReviewItem item = this.reviewitem;
        final AtomicReference result = new AtomicReference();
        final ReviewBehavior reviewBehavior = this.annotationInput.getBehavior();
        if (!this.commentEditor.getState().equals((Object)InlineCommentEditor.CommentEditorState.VIEW)) {
            Job job = new Job(Messages.CommandServerOperation){

                public boolean belongsTo(Object family) {
                    return family.equals(InlineCommentSubmitter.JOB_FAMILY);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    IStatus status = null;
                    switch (InlineCommentSubmitter.this.commentEditor.getState()) {
                        case REPLY: 
                        case EDIT: {
                            status = reviewBehavior.addComment(item, comment, monitor);
                            if (!status.isOK()) break;
                            result.set(status);
                            InlineCommentSubmitter.this.updateClient(comment, item);
                            return Status.OK_STATUS;
                        }
                        case DISCARD: {
                            status = reviewBehavior.discardComment(item, comment, monitor);
                            if (!status.isOK()) break;
                            result.set(status);
                            InlineCommentSubmitter.this.updateClient(comment, item);
                            return Status.OK_STATUS;
                        }
                        default: {
                            Assert.isTrue((boolean)false, (String)("Unknown state " + (Object)((Object)InlineCommentSubmitter.this.commentEditor.getState())));
                        }
                    }
                    InlineCommentSubmitter.this.processServerError(status.getMessage());
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
    }

    private void updateClient(IComment comment, IReviewItem item) {
        comment.setAuthor(this.getCurrentUser());
        if (this.commentEditor.getState().equals((Object)InlineCommentEditor.CommentEditorState.REPLY)) {
            item.getComments().add(comment);
        } else if (this.commentEditor.getState().equals((Object)InlineCommentEditor.CommentEditorState.DISCARD)) {
            commentlist = item.getComments();
            Iterator iter = commentlist.iterator();
            while (iter.hasNext()) {
                IComment element = (IComment)iter.next();
                if (element.getId() == null || !element.getId().equals(this.commentEditor.getCurrentComment().getId())) continue;
                iter.remove();
                break;
            }
        } else {
            commentlist = item.getComments();
            int i = 0;
            while (i < commentlist.size()) {
                if (((IComment)commentlist.get(i)).getId() != null && ((IComment)commentlist.get(i)).getId().equals(this.commentEditor.getCurrentComment().getId())) {
                    item.getComments().set(i, comment);
                    break;
                }
                ++i;
            }
        }
        IFileItem file = null;
        if (item instanceof IFileItem) {
            file = (IFileItem)item;
        } else if (item instanceof IFileVersion) {
            file = ((IFileVersion)item).getFile();
        }
        if (file != null && file.getReview() != null) {
            this.updateConsumer(file);
        }
    }

    private void processServerError(final String message) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog dialog = new MessageDialog(null, Messages.CommentPopupDialog_ServerError, null, message, 1, new String[]{IDialogConstants.CANCEL_LABEL}, 0);
                dialog.open();
            }
        });
    }

    private void updateConsumer(IFileItem file) {
        ReviewBehavior reviewBehavior = this.annotationInput.getBehavior();
        TaskRepository taskRepository = TasksUi.getRepositoryManager().getRepository(reviewBehavior.getTask().getConnectorKind(), reviewBehavior.getTask().getRepositoryUrl());
        ReviewsConnector connector = (ReviewsConnector)TasksUiPlugin.getConnector((String)reviewBehavior.getTask().getConnectorKind());
        IReviewRemoteFactoryProvider factoryProvider = (IReviewRemoteFactoryProvider)connector.getReviewClient(taskRepository).getFactoryProvider();
        RemoteEmfConsumer consumer = factoryProvider.getReviewItemSetContentFactory().getConsumerForLocalKey((EObject)file.getSet(), (Object)file.getSet().getId());
        consumer.updateObservers();
        consumer.release();
    }

    private IUser getCurrentUser() {
        if (this.reviewitem != null && this.reviewitem.getReview() != null && this.reviewitem.getReview().getRepository() != null) {
            return this.reviewitem.getReview().getRepository().getAccount();
        }
        return null;
    }

    protected ILineLocation getSelectedLineLocation() {
        ILineLocation location = IReviewsFactory.INSTANCE.createLineLocation();
        ILineRange lineRange = IReviewsFactory.INSTANCE.createLineRange();
        lineRange.setStart(this.range.getStartLine());
        lineRange.setEnd(this.range.getStartLine() + this.range.getNumberOfLines());
        location.getRanges().add(lineRange);
        return location;
    }
}

